<?php

require_once IPSLib::getAppDir( 'surly' ) . '/extensions/surly.php';

class admin_surly_surly_surly extends ipsCommand 
{
    const SURLY_PANEL_URL = 'https://surdotly.com/settings/';
    const SURLY_TAB_SETTINGS_PLUGIN = 'settings-plugin';
    const SURLY_TAB_SETTINGS_TOOLBAR = 'settings-toolbar';

    public $html;
    public $form_code = '';

    public function doExecute( ipsRegistry $registry )
    {
        $this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'surly_manage' );
        $this->registry->getClass('class_localization')->loadLanguageFile( array( 'admin_surly' ) );

        $this->registry->output->addToDocumentHead( 'inlinecss', '@import url( https://fonts.googleapis.com/css?family=Noto+Sans:400,400i,700,700i)' );
        $this->registry->output->addToDocumentHead( 'importcss', $this->settings['skin_app_url'] . 'static/css/font-awesome.min.css' );
        $this->registry->output->addToDocumentHead( 'importcss', $this->settings['skin_app_url'] . 'static/css/surly-style.css' );
        $this->registry->output->addToDocumentHead( 'importcss', $this->settings['skin_app_url'] . 'static/css/chosen.css' );

        $this->form_code = $this->html->form_code = 'module=surly&amp;section=surly&amp;';
        $this->form_code_js = $this->html->form_code_js = 'module=surly&section=surly&';

        if ( ipsRegistry::$settings['surly_initial'] ) {
            $this->html = $this->registry->output->loadTemplate( 'surly_settings_initial' );
            $this->settingsInitial();
        }
        else if ( ipsRegistry::$settings['surly_toolbar_id'] ) {
            if ( $this->request['do'] == self::SURLY_TAB_SETTINGS_TOOLBAR ) {
                $this->html = $this->registry->output->loadTemplate( 'surly_settings_toolbar' );
                $this->settingsToolbar();
            }
            else {
                $this->html = $this->registry->output->loadTemplate( 'surly_settings_plugin' );
                $this->settingsPlugin();
            }
        }
        else {
            $this->html = $this->registry->output->loadTemplate( 'surly_settings_short' );
            $this->settingsShort();
        }

        $this->registry->output->html_main .= $this->registry->output->global_template->global_frame_wrapper();
        $this->registry->output->sendOutput();
    }

    protected function settingsShort()
    {
        $surlyReplaceUrls = json_decode( ipsRegistry::$settings['surly_replace_urls'], TRUE );

        $this->registry->output->html .= $this->html->show(
            $surlyReplaceUrls
        );
    }

    protected function settingsInitial()
    {
        $surlyReplaceUrls = json_decode( ipsRegistry::$settings['surly_replace_urls'], TRUE );
        $surlyTrustedDomains = json_decode( ipsRegistry::$settings['surly_trusted_domains'], TRUE );
        $surlyTrustedDomainsLength = count($surlyTrustedDomains);
        $surlyTrustedGroups = json_decode( ipsRegistry::$settings['surly_trusted_groups'], TRUE );
        $surlySubdomain = ipsRegistry::$settings['surly_subdomain'] ?: '';
        $surlyInitial = ipsRegistry::$settings['surly_initial'] ?: '1-0';
        $surlyAuthUrl = self::SURLY_PANEL_URL . 'auth/?' . http_build_query(array(
            'url' => ipsRegistry::$settings['_base_url'],
            'cmsId' => SurlyIpb::CMS_ID,
            'meta' => array('cms_version' => IPB_VERSION),
        ));

        $this->lang->words['surly_description_shorten_urls'] = sprintf(
            $this->lang->words['surly_description_shorten_urls'],
            (ipsRegistry::$settings['surly_toolbar_id'] ?: SURLY_DEFAULT_TOOLBAR_ID)
        );

        $this->registry->output->html .= $this->html->show(
            $surlyReplaceUrls,
            $surlyTrustedDomains,
            $surlyTrustedDomainsLength,
            $surlyTrustedGroups,
            $surlySubdomain,
            $surlyInitial,
            $surlyAuthUrl
        );
    }

    protected function settingsPlugin()
    {
        $surlyReplaceUrls = json_decode( ipsRegistry::$settings['surly_replace_urls'], TRUE );
        $surlyTrustedDomains = json_decode( ipsRegistry::$settings['surly_trusted_domains'], TRUE );
        $surlyTrustedDomainsLength = count($surlyTrustedDomains);
        $surlyTrustedGroups = json_decode( ipsRegistry::$settings['surly_trusted_groups'], TRUE );
        $surlySubdomain = ipsRegistry::$settings['surly_subdomain'] ?: '';

        $this->lang->words['surly_description_shorten_urls'] = sprintf(
            $this->lang->words['surly_description_shorten_urls'],
            (ipsRegistry::$settings['surly_toolbar_id'] ?: SURLY_DEFAULT_TOOLBAR_ID)
        );

        $this->registry->output->html .= $this->html->show(
            $surlyReplaceUrls,
            $surlyTrustedDomains,
            $surlyTrustedDomainsLength,
            $surlyTrustedGroups,
            $surlySubdomain
        );
    }

    protected function settingsToolbar()
    {
        $surlyPanelUrl = self::SURLY_PANEL_URL . ipsRegistry::$settings['surly_toolbar_id'] . '/plugin_access?password=' . ipsRegistry::$settings['surly_toolbar_password'];

        $this->registry->output->html .= $this->html->show(
            $surlyPanelUrl
        );
    }
}