<?php

class surly_settings_initial extends output
{
    public function show($surlyReplaceUrls, $surlyTrustedDomains, $surlyTrustedDomainsLength, $surlyTrustedGroups, $surlySubdomain, $surlyInitial, $surlyAuthUrl) {
        $IPBHTML = '';

        $IPBHTML .= <<<EOF
        <div class="wrapper-surly" data-surly-initial="{$surlyInitial}" data-surly-module-url="{$this->settings['base_url']}{$this->form_code_js}section=surly&module=ajax&">
            <div class="ps-window">
                <div class="ps-top-title">
                    <p>{$this->lang->words['surly_tab_plugin_settings']}</p>
                </div>
                <div class="ps-window-content">
                    <div class="ps-left-side">
                        <div class="ps-left-content">
                            <div class="ps-step-menu">
                                <ul id="initial-steps" class="ps-menu">
                                    <li>
                                        <div class="ps-num-item"><span>1</span></div>
                                        <div class="ps-name-item"><p><span>{$this->lang->words['surly_title_registration']}</span></p></div>
                                    </li>
                                    <li>
                                        <div class="ps-num-item"><span>2</span></div>
                                        <div class="ps-name-item"><p><span>{$this->lang->words['surly_title_domains']}</span></p></div>
                                        <div class="ps-sub-menu">
                                            <ul>
                                                <li>
                                                    <span class="sline"></span>
                                                    <div class="ps-sub-name-item"><p><span>{$this->lang->words['surly_title_subdomain']}</span></p></div>
                                                </li>
                                                <li>
                                                    <span class="sline hlast"></span>
                                                    <div class="ps-sub-name-item"><p><span>{$this->lang->words['surly_title_trusted_domains']}</span></p></div>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                    <li>
                                        <div class="ps-num-item"><span>3</span></div>
                                        <div class="ps-name-item"><p><span>{$this->lang->words['surly_title_trusted_groups']}</span></p></div>
                                    </li>
                                    <li>
                                        <div class="ps-num-item"><span>4</span></div>
                                        <div class="ps-name-item"><p><span>{$this->lang->words['surly_title_url_processing']}</span></p></div>
                                        <div class="ps-sub-menu">
                                            <ul>
                                                <li>
                                                    <span class="sline"></span>
                                                    <div class="ps-sub-name-item"><p><span>{$this->lang->words['surly_title_shorten_urls']}</span></p></div>
                                                </li>
                                                <li>
                                                    <div class="ps-sub-name-item"><p><span>{$this->lang->words['surly_title_replace_urls']}</span></p></div>
                                                </li>
                                            </ul>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="ps-right-side">
                        <div class="ps-right-content">
                            <div id="surly-initial-step-1-0" style="display:none">
EOF;
                            if (!$this->settings['surly_toolbar_password']) {
                                $IPBHTML .= <<<EOF
                                <iframe frameborder="0" scrolling="no" class="surly-auth" src="{$surlyAuthUrl}"></iframe>
EOF;
                            }
                                $IPBHTML .= <<<EOF
                            </div>
                            <form id="surly-initial-step-2-1" style="display:none">
                                <div class="ps-info-text">
                                    <p>{$this->lang->words['surly_description_subdomain']}</p>
                                </div>
                                <div class="ps-cell">
                                    <div class="surly-field-error" data-field="surly-subdomain"></div>
                                </div>
                                <div class="ps-next-form">
                                    <div class="ps-left-row">
                                        <div class="ps-list">
                                            <ul>
                                                <li>
                                                    <div class="ps-type-in">
                                                        <input name="surly_subdomain" value="{$surlySubdomain}" type="text" placeholder="{$this->lang->words['surly_placeholder_url']}"/>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="ps-type-buttons">
                                                        <a id="surly-save-subdomain" href="#" class="ps-type-button ps-icon blue">{$this->lang->words['surly_button_next']}<span> &rarr;</span></a>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <div id="surly-initial-step-2-2" style="display:none">
                                <div class="ps-info-text">
                                    <p>{$this->lang->words['surly_description_trusted_domains']}</p>
                                </div>
                                <div class="ps-next-form">
                                    <div class="ps-list">
                                        <ul>
                                            <li>
                                                <form id="surly-trusted-domains">
                                                    <div class="ps-adding">
                                                        <div class="ps-inner-box">
                                                            <div class="ps-table-box">
                                                                <div class="ps-cell">
                                                                    <div class="w430">
                                                                        <div class="ps-type-in">
                                                                            <input id="surly-trusted-domain" name="surly_trusted_domain" value="" placeholder="{$this->lang->words['surly_placeholder_domain']}"/>
                                                                            <div class="ps-type-buttons">
                                                                                <a id="surly-save-trusted-domain" href="#" class="ps-type-button blue">{$this->lang->words['surly_button_add_domain']}</a>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="ps-cell">
                                                                    <div class="surly-field-error" data-field="surly-trusted-domain"></div>
                                                                </div>
                                                            </div>
                                                            <div class="ps-central-box">
                                                                <div class="ps-table-line">
                                                                    <ul>
                                                                        <li class="first">
                                                                            <span class="ps-type-check">
                                                                                <input type="checkbox" id="surly_trusted_domains">
                                                                            </span>
                                                                            <label for="surly_trusted_domains">{$this->lang->words['surly_label_domain']}</label>
                                                                            <span class="num-item">
EOF;
                                                                            if ($surlyTrustedDomainsLength == 1) {
                                                                                $IPBHTML .= <<<EOF
                                                                                1 {$this->lang->words['surly_label_item']}
EOF;
                                                                            } else {
                                                                                $IPBHTML .= <<<EOF
                                                                                {$surlyTrustedDomainsLength} {$this->lang->words['surly_label_items']}
EOF;
                                                                            }
                                                                            $IPBHTML .= <<<EOF
                                                                            </span>
                                                                        </li>
EOF;
                                                                        foreach ($surlyTrustedDomains as $key => $value) {
                                                                            $IPBHTML .= <<<EOF
                                                                            <li class="inner">
                                                                                <span class="ps-type-check">
                                                                                    <input
                                                                                        id="surly_trusted_domains-{$key}"
                                                                                        name="surly_trusted_domains[]"
                                                                                        value="{$value}"
                                                                                        type="checkbox"/>
                                                                                </span>
                                                                                <label for="surly_trusted_domains-{$key}">{$value}</label>
                                                                            </li>
EOF;
                                                                        }
                                                                        if ($surlyTrustedDomainsLength) {
                                                                            $IPBHTML .= <<<EOF
                                                                            <li class="empty hide">
EOF;
                                                                        } else {
                                                                            $IPBHTML .= <<<EOF
                                                                            <li class="empty">
EOF;
                                                                        }
                                                                        $IPBHTML .= <<<EOF
                                                                            <label>{$this->lang->words['surly_label_no_items_found']}</label>
                                                                        </li>
                                                                    </ul>
                                                                    <div class="ps-type-buttons">
                                                                        <a id="surly-delete-trusted-domains" href="#" class="ps-type-button ps-border lred pad30">{$this->lang->words['surly_button_delete']}</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </li>
                                            <li>
                                                <div class="ps-type-buttons">
                                                    <a id="surly-save-trusted-domains" href="#" class="ps-type-button ps-icon blue">{$this->lang->words['surly_button_next']}<span> &rarr;</span></a>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <form id="surly-initial-step-3-0" style="display:none">
                                <div class="ps-info-text">
                                    <p>{$this->lang->words['surly_description_trusted_groups']}</p>
                                </div>
                                <div class="ps-next-form">
                                    <div class="ps-left-row">
                                        <div class="ps-list">
                                            <ul>
                                                <li>
                                                    <div class="ps-list-in trusted-groups">
                                                        <ul>
EOF;
                                                        foreach (ipsRegistry::cache()->getCache( 'group_cache' ) as $key => $value) {
                                                            $IPBHTML .= <<<EOF
                                                            <li>
                                                                <label for="surly_trusted_groups-{$key}">
                                                                    {$value['g_title']}
                                                                </label>
                                                                <input
EOF;
                                                                if (in_array($key, $surlyTrustedGroups)) {
                                                                    $IPBHTML .= <<<EOF
                                                                    checked="checked"
EOF;
                                                                }
                                                                $IPBHTML .= <<<EOF
                                                                    id="surly_trusted_groups-{$key}"
                                                                    name="surly_trusted_groups[]"
                                                                    value="{$key}"
                                                                    type="checkbox"/>
                                                            </li>
EOF;
                                                    }
                                                    $IPBHTML .= <<<EOF
                                                        </ul>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="ps-type-buttons">
                                                        <a id="surly-save-trusted-groups" href="#" class="ps-type-button ps-icon blue">{$this->lang->words['surly_button_next']}<span> &rarr;</span></a>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <form id="surly-initial-step-4-1" style="display:none">
                                <div class="ps-info-text">
                                    <p>{$this->lang->words['surly_description_shorten_urls']}</p>
                                </div>
                                <div class="ps-next-form">
                                    <div class="ps-left-row">
                                        <div class="ps-list">
                                            <ul>
                                                <li>
                                                    <div class="ps-select-in">
                                                        <select name="surly_shorten_urls">
                                                            <option
EOF;
                                                            if (!$this->settings['surly_shorten_urls']) {
                                                                $IPBHTML .= <<<EOF
                                                                selected="selected"
EOF;
                                                            }
                                                            $IPBHTML .= <<<EOF
                                                                value="0">
                                                                {$this->lang->words['surly_option_disable']}
                                                            </option>

                                                            <option
EOF;
                                                            if ($this->settings['surly_shorten_urls']) {
                                                                $IPBHTML .= <<<EOF
                                                                selected="selected"
EOF;
                                                            }
                                                            $IPBHTML .= <<<EOF
                                                                value="1">
                                                                {$this->lang->words['surly_option_enable']}
                                                            </option>
                                                        </select>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="ps-type-buttons">
                                                        <a id="surly-save-shorten-urls" href="#" class="ps-type-button ps-icon blue">
                                                            {$this->lang->words['surly_button_next']}<span> &rarr;</span>
                                                        </a>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <form id="surly-initial-step-4-2" style="display:none">
                                <div class="ps-info-text">
                                    <p>{$this->lang->words['surly_description_replace_urls']}</p>
                                </div>
                                <div class="ps-next-form">
                                    <div class="ps-left-row">
                                        <div class="ps-list">
                                            <ul>
                                                <li>
                                                    <div class="ps-list-in">
                                                        <ul>
                                                            <li>
                                                                <label for="surly_replace_urls_nowhere">{$this->lang->words['surly_option_nowhere']}</label>
                                                                <input
EOF;
                                                                if (in_array(0, $surlyReplaceUrls)) {
                                                                    $IPBHTML .= <<<EOF
                                                                    checked="checked"
EOF;
                                                                }
                                                                $IPBHTML .= <<<EOF
                                                                    id="surly_replace_urls_nowhere"
                                                                    name="surly_replace_urls[]"
                                                                    value="0"
                                                                    type="checkbox"/>
                                                            </li>
                                                            <li>
                                                                <label for="surly_replace_urls_posts">{$this->lang->words['surly_option_posts']}</label>
                                                                <input
EOF;
                                                                if (in_array(1, $surlyReplaceUrls)) {
                                                                    $IPBHTML .= <<<EOF
                                                                    checked="checked"
EOF;
                                                                }
                                                                $IPBHTML .= <<<EOF
                                                                    id="surly_replace_urls_posts"
                                                                    name="surly_replace_urls[]"
                                                                    value="1"
                                                                    type="checkbox"/>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="ps-type-buttons">
                                                        <a id="surly-save-replace-urls" href="#" class="ps-type-button blue">{$this->lang->words['surly_button_finish']}</a>
                                                    </div>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script type="text/javascript" src="{$this->settings['skin_app_url']}static/js/chosen.jquery.min.js"></script>
        <script type="text/javascript" src="{$this->settings['skin_app_url']}static/js/jquery.icheck.min.js"></script>
        <script type="text/javascript" src="{$this->settings['skin_app_url']}static/js/jquery.postMessage.min.js"></script>
        <script type="text/javascript" src="{$this->settings['skin_app_url']}static/js/surly-script.js"></script>
EOF;

        return $IPBHTML;
    }
}