<?php

defined('_JEXEC') or die( 'Restricted access' );

class SurlyControllerAjax extends SurlyController
{
	var $params;

	function __construct($config = array())
	{
		parent::__construct($config);

		$this->params = JComponentHelper::getParams(JRequest::getVar('option'));
	}

	function sendJson($data = null, $message = null, $error = false)
	{
		JResponse::setHeader('Content-Type', 'application/json; charset=utf-8');
		JResponse::sendHeaders();

		echo json_encode(array('success' => !$error, 'message' => $message, 'data' => $data));

		jexit();
	}

	function entryParams()
	{
		$table =& JTable::getInstance('component');
		$table->loadByOption('com_surly');
		$table->bind(array('params' => $this->params->toString(), 'option' => 'com_surly'));

		if (!$table->check()) {
			return false;
		}

		if (!$table->store()) {
			return false;
		}
	}

	function entrySubdomain()
	{
		$surlySubdomain = JRequest::getVar('surly_subdomain', '');

		if ($surlySubdomain != $this->params->get('surly_subdomain', '')) {
			if ($surlySubdomain == '') {
				SurlyJoomla::instance()->trackHistory(SurlyJoomla::SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK);
			}
			else {
				$result = json_decode(SurlyJoomla::instance()->linkSubdomain($surlySubdomain), true);

				if (isset($result['error_code'])) {
					$errors = array(
						1 => JText::_('SURLY_ERROR_SUBDOMAIN_REQUIRE'),
						2 => JText::_('SURLY_ERROR_SUBDOMAIN_INVALID'),
						3 => JText::_('SURLY_ERROR_SUBDOMAIN_EXIST'),
						4 => JText::_('SURLY_ERROR_SUBDOMAIN_CNAME'),
						5 => JText::_('SURLY_ERROR_UNEXPECTED'),
					);

					return isset($errors[$result['error_code']])
						? array('error' => $errors[$result['error_code']])
						: array('error' => $errors[5]);
				}
				elseif (isset($result['subdomain'])) {
					$surlySubdomain = $result['subdomain'];

					SurlyJoomla::instance()->trackHistory(SurlyJoomla::SURLY_ACTION_TYPE_SUBDOMAIN_LINK);
				}
				else {
					$surlySubdomain = $this->params->get('surly_subdomain', '');
				}
			}
		}

		$this->params->bind(array('surly_subdomain' => $surlySubdomain));

		return $this->entryParams();
	}

	function entryTrustedGroups()
	{
		$surlyTrustedGroups = (array) JRequest::getVar('surly_trusted_groups', array());

		$db = JFactory::getDbo();

		$db->setQuery('SELECT a.id'
			. ' FROM #__core_acl_aro_groups AS a'
			. ' WHERE a.name NOT IN ("ROOT", "USERS", "Public Backend")');
		$groups = $db->loadAssocList('id');

		foreach ($surlyTrustedGroups as $key => $value) {
			if (!isset($groups[$value])) {
				unset($surlyTrustedGroups[$key]);
			}
		}

		$this->params->bind(array('surly_trusted_groups' => $surlyTrustedGroups));

		return $this->entryParams();
	}

	function entryShortenUrls()
	{
		$surlyShortenUrls = (bool) JRequest::getVar('surly_shorten_urls', false);

		$this->params->bind(array('surly_shorten_urls' => $surlyShortenUrls));

		return $this->entryParams();
	}

	function entryReplaceUrls()
	{
		$surlyReplaceUrls = (array) JRequest::getVar('surly_replace_urls', array(0));

		$surlyReplaceUrls = array_intersect(array(0), $surlyReplaceUrls)
			?: array_intersect(array(1, 2), $surlyReplaceUrls)
			?: array(0);

		$this->params->bind(array('surly_replace_urls' => array_values($surlyReplaceUrls)));

		return $this->entryParams();
	}

	function saveToolbarSettings()
	{
		$this->params->bind(array(
			'surly_toolbar_id' => JRequest::getVar('surly_toolbar_id', ''),
			'surly_toolbar_password' => JRequest::getVar('surly_toolbar_password', ''),
			'surly_initial' => '2-1',
		));

		$this->entryParams();

		SurlyJoomla::instance()->trackHistory(SurlyJoomla::SURLY_ACTION_TYPE_AUTH);

		$this->sendJson();
	}

	function saveSubdomain()
	{
		$result = $this->entrySubdomain();

		if (isset($result['error'])) {
			$this->sendJson(null, $result['error'], true);
		}

		$this->params->bind(array('surly_initial' => '2-2'));

		$this->entryParams();

		$this->sendJson();
	}

	function saveTrustedGroups()
	{
		$this->entryTrustedGroups();

		$this->params->bind(array('surly_initial' => '4-1'));

		$this->entryParams();

		$this->sendJson();
	}

	function saveShortenUrls()
	{
		$this->entryShortenUrls();

		$this->params->bind(array('surly_initial' => '4-2'));

		$this->entryParams();

		$this->sendJson();
	}

	function saveReplaceUrls()
	{
		$this->entryReplaceUrls();

		$this->params->bind(array('surly_initial' => false));

		$this->entryParams();

		SurlyJoomla::instance()->trackHistory(SurlyJoomla::SURLY_ACTION_TYPE_ACTIVATION);

		$this->sendJson();
	}

	function skipStep()
	{
		$steps = array('1-0', '2-1', '2-2', '3-0', '4-1', '4-2');

		$next_step = JRequest::getVar('next_step', $steps[0]);
		$next_step = in_array($next_step, $steps) ? $next_step : $steps[0];

		$this->params->bind(array('surly_initial' => $next_step));

		$this->entryParams();

		$this->sendJson();
	}

	function saveSettings()
	{
		$this->entryReplaceUrls();
		$this->entryShortenUrls();
		$this->entryTrustedGroups();

		$result = $this->entrySubdomain();

		if (isset($result['error'])) {
			$this->sendJson(null, $result['error'], true);
		}

		$this->sendJson();
	}

	function saveTrustedDomain()
	{
		$trustedDomain = preg_replace('/^https?:\/\/(.+)/',"$1", strtolower(trim(JRequest::getVar('surly_trusted_domain', ''))));

		if (empty($trustedDomain)) {
			$this->sendJson(null, JText::_('SURLY_ERROR_DOMAIN_NAME'), true);
		}

		if (preg_match('!(?P<host>(?:[a-z0-9_-]+\.)+[a-z]+)!u', $trustedDomain, $result)) {
			$trustedDomain = $result['host'];
		}
		else {
			$this->sendJson(null, JText::_('SURLY_ERROR_DOMAIN_NAME'), true);
		}

		$surlyTrustedDomains = (array) $this->params->get('surly_trusted_domains', array());

		if (in_array($trustedDomain, $surlyTrustedDomains)) {
			$this->sendJson(null, JText::_('SURLY_ERROR_DOMAIN_EXIST'), true);
		}

		$surlyTrustedDomains = array_merge($surlyTrustedDomains, array($trustedDomain));

		$this->params->bind(array('surly_trusted_domains' => $surlyTrustedDomains));

		$this->entryParams();

		$this->sendJson(array('domain' => $trustedDomain));
	}

	function deleteTrustedDomains()
	{
		$trustedDomains = (array) JRequest::getVar('surly_trusted_domains', array());

		$surlyTrustedDomains = (array) $this->params->get('surly_trusted_domains', array());

		$surlyTrustedDomains = array_diff($surlyTrustedDomains, $trustedDomains);

		$this->params->bind(array('surly_trusted_domains' => $surlyTrustedDomains));

		$this->entryParams();

		$this->sendJson();
	}
}
