<?php

defined('_JEXEC') or die;

class SurlyControllerAjax extends SurlyControllerLegacy
{
	protected $params;

	public function __construct($properties)
	{
		parent::__construct($properties);

		$this->params = JComponentHelper::getParams(JRequest::getVar('option'));
	}

	protected function sendJson($data = null, $message = null, $error = false)
	{
		if (version_compare(JVERSION, '3.0', 'ge')) {
			$app = JFactory::getApplication();
			$app->mimeType = 'application/json';
			$app->setHeader('Content-Type', $app->mimeType . '; charset=' . $app->charSet);
			$app->sendHeaders();

			echo new JResponseJson($data, $message, $error);

			$app->close();
		}
		else {
			JResponse::setHeader('Content-Type', 'application/json; charset=utf-8');
			JResponse::sendHeaders();

			echo json_encode(array('success' => !$error, 'message' => $message, 'data' => $data));

			jexit();
		}
	}

	protected function entryParams()
	{
		$table = JTable::getInstance('extension');
		$table->load(JComponentHelper::getComponent(JRequest::getVar('option'))->id);
		$table->bind(array('params' => $this->params->toString()));

		if (!$table->check()) {
			return false;
		}

		if (!$table->store()) {
			return false;
		}
	}

	protected function entrySubdomain()
	{
		$surlySubdomain = JRequest::getVar('surly_subdomain', '');

		if ($surlySubdomain != $this->params->get('surly_subdomain', '')) {
			if ($surlySubdomain == '') {
				SurlyJoomla::instance()->trackHistory(SurlyJoomla::SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK);
			}
			else {
				$result = json_decode(SurlyJoomla::instance()->linkSubdomain($surlySubdomain), true);

				if (isset($result['error_code'])) {
					$errors = array(
						1 => JText::_('SURLY_ERROR_SUBDOMAIN_REQUIRE'),
						2 => JText::_('SURLY_ERROR_SUBDOMAIN_INVALID'),
						3 => JText::_('SURLY_ERROR_SUBDOMAIN_EXIST'),
						4 => JText::_('SURLY_ERROR_SUBDOMAIN_CNAME'),
						5 => JText::_('SURLY_ERROR_UNEXPECTED'),
					);

					return isset($errors[$result['error_code']])
						? array('error' => $errors[$result['error_code']])
						: array('error' => $errors[5]);
				}
				elseif (isset($result['subdomain'])) {
					$surlySubdomain = $result['subdomain'];

					SurlyJoomla::instance()->trackHistory(SurlyJoomla::SURLY_ACTION_TYPE_SUBDOMAIN_LINK);
				}
				else {
					$surlySubdomain = $this->params->get('surly_subdomain', '');
				}
			}
		}

		$this->params->set('surly_subdomain', $surlySubdomain);

		return $this->entryParams();
	}

	protected function entryTrustedGroups()
	{
		$surlyTrustedGroups = (array) JRequest::getVar('surly_trusted_groups', array());

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('a.id');
		$query->from($db->quoteName('#__usergroups') . ' AS a');
		$db->setQuery($query);

		$groups = $db->loadColumn();

		foreach ($surlyTrustedGroups as $key => $value) {
			if (!in_array($value, $groups)) {
				unset($surlyTrustedGroups[$key]);
			}
		}

		$this->params->set('surly_trusted_groups', $surlyTrustedGroups);

		return $this->entryParams();
	}

	protected function entryShortenUrls()
	{
		$surlyShortenUrls = (bool) JRequest::getVar('surly_shorten_urls', false);

		$this->params->set('surly_shorten_urls', $surlyShortenUrls);

		return $this->entryParams();
	}

	protected function entryReplaceUrls()
	{
		$surlyReplaceUrls = (array) JRequest::getVar('surly_replace_urls', array(0));

		$surlyReplaceUrls = array_intersect(array(0), $surlyReplaceUrls)
			?: array_intersect(array(1, 2), $surlyReplaceUrls)
			?: array(0);

		$this->params->set('surly_replace_urls', array_values($surlyReplaceUrls));

		return $this->entryParams();
	}

	public function saveToolbarSettings()
	{
		$this->params->set('surly_toolbar_id', JRequest::getVar('surly_toolbar_id', ''));
		$this->params->set('surly_toolbar_password', JRequest::getVar('surly_toolbar_password', ''));
		$this->params->set('surly_initial', '2-1');

		$this->entryParams();

		SurlyJoomla::instance()->trackHistory(SurlyJoomla::SURLY_ACTION_TYPE_AUTH);

		$this->sendJson();
	}

	public function saveSubdomain()
	{
		$result = $this->entrySubdomain();

		if (isset($result['error'])) {
			$this->sendJson(null, $result['error'], true);
		}

		$this->params->set('surly_initial', '2-2');

		$this->entryParams();

		$this->sendJson();
	}

	public function saveTrustedGroups()
	{
		$this->entryTrustedGroups();

		$this->params->set('surly_initial', '4-1');

		$this->entryParams();

		$this->sendJson();
	}

	public function saveShortenUrls()
	{
		$this->entryShortenUrls();

		$this->params->set('surly_initial', '4-2');

		$this->entryParams();

		$this->sendJson();
	}

	public function saveReplaceUrls()
	{
		$this->entryReplaceUrls();

		$this->params->set('surly_initial', false);

		$this->entryParams();

		SurlyJoomla::instance()->trackHistory(SurlyJoomla::SURLY_ACTION_TYPE_ACTIVATION);

		$this->sendJson();
	}

	public function skipStep()
	{
		$steps = array('1-0', '2-1', '2-2', '3-0', '4-1', '4-2');

		$next_step = JRequest::getVar('next_step', $steps[0]);
		$next_step = in_array($next_step, $steps) ? $next_step : $steps[0];

		$this->params->set('surly_initial', $next_step);

		$this->entryParams();

		$this->sendJson();
	}

	public function saveSettings()
	{
		$this->entryReplaceUrls();
		$this->entryShortenUrls();
		$this->entryTrustedGroups();

		$result = $this->entrySubdomain();

		if (isset($result['error'])) {
			$this->sendJson(null, $result['error'], true);
		}

		$this->sendJson();
	}

	public function saveTrustedDomain()
	{
		$trustedDomain = preg_replace('/^https?:\/\/(.+)/',"$1", strtolower(trim(JRequest::getVar('surly_trusted_domain', ''))));

		if (empty($trustedDomain)) {
			$this->sendJson(null, JText::_('SURLY_ERROR_DOMAIN_NAME'), true);
		}

		if (preg_match('!(?P<host>(?:[a-z0-9_-]+\.)+[a-z]+)!u', $trustedDomain, $result)) {
			$trustedDomain = $result['host'];
		}
		else {
			$this->sendJson(null, JText::_('SURLY_ERROR_DOMAIN_NAME'), true);
		}

		$surlyTrustedDomains = $this->params->get('surly_trusted_domains', array());

		if (in_array($trustedDomain, $surlyTrustedDomains)) {
			$this->sendJson(null, JText::_('SURLY_ERROR_DOMAIN_EXIST'), true);
		}

		$surlyTrustedDomains = array_merge($surlyTrustedDomains, array($trustedDomain));

		$this->params->set('surly_trusted_domains', $surlyTrustedDomains);

		$this->entryParams();

		$this->sendJson(array('domain' => $trustedDomain));
	}

	public function deleteTrustedDomains()
	{
		$trustedDomains = (array) JRequest::getVar('surly_trusted_domains', array());

		$surlyTrustedDomains = $this->params->get('surly_trusted_domains', array());

		$surlyTrustedDomains = array_diff($surlyTrustedDomains, $trustedDomains);

		$this->params->set('surly_trusted_domains', $surlyTrustedDomains);

		$this->entryParams();

		$this->sendJson();
	}
}