<?php

defined('_JEXEC') or die;

abstract class JHtmlSurly
{
	protected static $loaded = array();

	public static function stylesheet()
	{
		if (!empty(self::$loaded[__METHOD__])) {
			return;
		}

		$document = JFactory::getDocument();
		$document->addStylesheet('https://fonts.googleapis.com/css?family=Noto+Sans:400,400i,700,700i', 'text/css', null);
		$document->addStylesheet(JURI::root(true) . '/administrator/components/com_surly/assets/css/font-awesome.min.css', 'text/css', null);
		$document->addStylesheet(JURI::root(true) . '/administrator/components/com_surly/assets/css/surly-style.css', 'text/css', null);
		$document->addStylesheet(JURI::root(true) . '/administrator/components/com_surly/assets/css/chosen.css', 'text/css', null);

		self::$loaded[__METHOD__] = true;

		return;
	}

	public static function jquery()
	{
		if (!empty(self::$loaded[__METHOD__])) {
			return;
		}

		$document = JFactory::getDocument();
		$document->addScript(JURI::root(true) . '/administrator/components/com_surly/assets/js/jquery-1.8.2.min.js');

		self::$loaded[__METHOD__] = true;

		return;
	}

	public static function script()
	{
		if (!empty(self::$loaded[__METHOD__])) {
			return;
		}

		$document = JFactory::getDocument();
		$document->addScript(JURI::root(true) . '/administrator/components/com_surly/assets/js/chosen.jquery.min.js');
		$document->addScript(JURI::root(true) . '/administrator/components/com_surly/assets/js/jquery.icheck.min.js');
		$document->addScript(JURI::root(true) . '/administrator/components/com_surly/assets/js/jquery.postMessage.min.js');
		$document->addScript(JURI::root(true) . '/administrator/components/com_surly/assets/js/surly-script.js');

		self::$loaded[__METHOD__] = true;

		return;
	}

	public static function bootstrap()
	{
		if (!empty(self::$loaded[__METHOD__])) {
			return;
		}

		if (version_compare(JVERSION, '3.0', 'lt')) {
			$document = JFactory::getDocument();
			$document->addStylesheet(JURI::root(true) . '/administrator/components/com_surly/assets/css/bootstrap-legacy.css');
			$document->addScript(JURI::root(true) . '/administrator/components/com_surly/assets/js/bootstrap-legacy.js');
		}

		self::$loaded[__METHOD__] = true;

		return;
	}

	public static function usergroups($selected = array())
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('a.*, COUNT(DISTINCT b.id) AS level');
		$query->from($db->quoteName('#__usergroups') . ' AS a');
		$query->join('LEFT', $db->quoteName('#__usergroups') . ' AS b ON a.lft > b.lft AND a.rgt < b.rgt');
		$query->group('a.id, a.title, a.lft, a.rgt, a.parent_id');
		$query->order('a.lft ASC');
		$db->setQuery($query);
		$groups = $db->loadObjectList();

		$html = array();

		for ($i = 0, $n = count($groups); $i < $n; $i++) {
			$item = & $groups[$i];

			$html[] = '<li>'
				. '<label for="surly_trusted_groups-' . $item->id . '">'
					. str_repeat('-', $item->level) . ' ' . $item->title
				. '</label>'
				. '<input type="checkbox" id="surly_trusted_groups-' . $item->id . '" name="surly_trusted_groups[]" value="' . $item->id . '"' . (in_array($item->id, $selected) ? ' checked="checked"' : '') . '/>'
			. '</li>';
		}

		return implode("\n", $html);
	}
}
