<?php
/*
 * Copyright (c) 2012 Sur.ly
 * This file is part of Sur.ly phpBB plugin.
 *
 * Sur.ly phpBB plugin plugin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Sur.ly phpBB plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Sur.ly phpBB plugin.  If not, see <http://www.gnu.org/licenses/>.
 */

if (!defined('IN_PHPBB'))
{
    exit;
}

include($phpbb_root_path . 'includes/functions_surly.' . $phpEx);

define('SURLY_REPLACE_URLS_NOWHERE', 0);
define('SURLY_REPLACE_URLS_POSTS', 1);

define('SURLY_PANEL_URL', 'https://surdotly.com/settings/');

define('SURLY_CMS_PHPBB', 5);

class acp_surly
{
	var $u_action;

	function main($id, $mode)
	{
		global $template, $user, $config;

		$template->assign_vars(array(
			'U_ACTION' => $this->u_action,
			'ACP_SURLY_MODULE' => true,
		));

		add_form_key('surly');

		if (request_var('action', '') && !check_form_key('surly'))
		{
			header('Content-Type: application/json');
			echo json_encode(array('error' => array('token' => $user->lang['FORM_INVALID'])));

			exit;
		}

		switch(request_var('action', ''))
		{
			case 'surly_ajax_save_toolbar_settings':
				$this->ajax_save_toolbar_settings();
				break;
			case 'surly_ajax_save_subdomain':
				$this->ajax_save_subdomain();
				break;
			case 'surly_ajax_save_trusted_groups':
				$this->ajax_save_trusted_groups();
				break;
			case 'surly_ajax_save_shorten_urls':
				$this->ajax_save_shorten_urls();
				break;
			case 'surly_ajax_save_replace_urls':
				$this->ajax_save_replace_urls();
				break;
			case 'surly_ajax_skip_step':
				$this->ajax_skip_step();
				break;
			case 'surly_ajax_save_settings':
				$this->ajax_save_settings();
				break;
			case 'surly_ajax_save_trusted_domain':
				$this->ajax_save_trusted_domain();
				break;
			case 'surly_ajax_delete_trusted_domains':
				$this->ajax_delete_trusted_domains();
				break;
		}

		$this->page_title = 'ACP_SURLY_TAB_PLUGIN_SETTINGS';

		if (!empty($config['surly_initial']))
		{
			$this->tpl_name = 'surly/template/surly-settings-initial';

			$this->display_settings_initial();
		}
		elseif (!empty($config['surly_toolbar_password']))
		{
			if ($mode == 'surly-settings-toolbar')
			{
				$this->page_title = 'ACP_SURLY_TAB_TOOLBAR_SETTINGS';
				$this->tpl_name = 'surly/template/surly-settings-toolbar';

				$this->display_settings_toolbar();
			}
			else
			{
				$this->tpl_name = 'surly/template/surly-settings-plugin';

				$this->display_settings_plugin();
			}
		}
		else
		{
			$this->tpl_name = 'surly/template/surly-settings-short';

			$this->display_settings_short();
		}
	}

	function display_settings_short()
	{
		global $config, $template;

		$surly_replace_urls = !empty($config['surly_replace_urls'])
			? json_decode($config['surly_replace_urls'], true) : array(SURLY_REPLACE_URLS_NOWHERE);

		$template->assign_vars(array(
			'SURLY_REPLACE_URLS_NOWHERE' => in_array(SURLY_REPLACE_URLS_NOWHERE, $surly_replace_urls),
			'SURLY_REPLACE_URLS_POSTS' => in_array(SURLY_REPLACE_URLS_POSTS, $surly_replace_urls),
		));
	}

	function display_settings_initial()
	{
		global $config, $template, $db, $user;

		$surly_replace_urls = !empty($config['surly_replace_urls'])
			? json_decode($config['surly_replace_urls'], true) : array(SURLY_REPLACE_URLS_NOWHERE);

		$surly_toolbar_id = !empty($config['surly_toolbar_id'])
			? $config['surly_toolbar_id'] : SURLY_DEFAULT_TOOLBAR_ID;

		$surly_toolbar_password = !empty($config['surly_toolbar_password'])
			? $config['surly_toolbar_password'] : '';

		$surly_subdomain = !empty($config['surly_subdomain'])
			? $config['surly_subdomain'] : '';

		$surly_trusted_groups = !empty($config['surly_trusted_groups'])
			? json_decode($config['surly_trusted_groups'], true) : array();

		$surly_trusted_domains = !empty($config['surly_ignore_domains'])
			? json_decode($config['surly_ignore_domains'], true) : array();

		$surly_initial = !empty($config['surly_initial'])
			? $config['surly_initial'] : '1-0';

		$surly_shorten_urls = !empty($config['surly_shorten_urls']);

		foreach ($surly_trusted_domains as $key => $value)
		{
			$template->assign_block_vars('surly_trusted_domains', array(
				'ID' => $key,
				'DOMAIN_NAME' => $value,
			));
		}

		$groups_sql = 'SELECT DISTINCT g.group_type, g.group_name, g.group_id
			FROM ' . GROUPS_TABLE . ' g
			ORDER BY g.group_type DESC, g.group_name ASC';

		$groups = $db->sql_query($groups_sql);

		while ($row = $db->sql_fetchrow($groups))
		{
			$template->assign_block_vars('surly_trusted_groups', array(
				'ID' => $row['group_id'],
				'NAME' => ($row['group_type'] == GROUP_SPECIAL) ? $user->lang('G_' . $row['group_name']) : $row['group_name'],
				'SELECTED' => in_array($row['group_id'], $surly_trusted_groups),
			));
		}

		$surly_auth_url = SURLY_PANEL_URL . 'auth/?' . http_build_query(array(
			'url' => generate_board_url(true),
			'cmsId' => SURLY_CMS_PHPBB,
			'meta' => array('cms_version' => PHPBB_VERSION),
		));

		$template->assign_vars(array(
			'L_ACP_SURLY_DESCRIPTION_SHORTEN_URLS' => sprintf($user->lang('ACP_SURLY_DESCRIPTION_SHORTEN_URLS'), $surly_toolbar_id),
			'U_SURLY_AUTH_URL' => $surly_auth_url,
			'SURLY_REPLACE_URLS_NOWHERE' => in_array(SURLY_REPLACE_URLS_NOWHERE, $surly_replace_urls),
			'SURLY_REPLACE_URLS_POSTS' => in_array(SURLY_REPLACE_URLS_POSTS, $surly_replace_urls),
			'SURLY_TOOLBAR_PASSWORD' => $surly_toolbar_password,
			'SURLY_SHORTEN_URLS' => $surly_shorten_urls,
			'SURLY_SUBDOMAIN' => $surly_subdomain,
			'SURLY_INITIAL' => $surly_initial,
			'SURLY_TRUSTED_DOMAINS_LENGTH' => count($surly_trusted_domains),
		));
	}

	function display_settings_plugin()
	{
		global $config, $template, $db, $user;

		$surly_replace_urls = !empty($config['surly_replace_urls'])
			? json_decode($config['surly_replace_urls'], true) : array(SURLY_REPLACE_URLS_NOWHERE);

		$surly_toolbar_id = !empty($config['surly_toolbar_id'])
			? $config['surly_toolbar_id'] : SURLY_DEFAULT_TOOLBAR_ID;

		$surly_trusted_groups = !empty($config['surly_trusted_groups'])
			? json_decode($config['surly_trusted_groups'], true) : array();

		$surly_trusted_domains = !empty($config['surly_ignore_domains'])
			? json_decode($config['surly_ignore_domains'], true) : array();

		$surly_subdomain = !empty($config['surly_subdomain'])
			? $config['surly_subdomain'] : '';

		$surly_shorten_urls = !empty($config['surly_shorten_urls']);

		foreach ($surly_trusted_domains as $key => $value)
		{
			$template->assign_block_vars('surly_trusted_domains', array(
				'ID' => $key,
				'DOMAIN_NAME' => $value,
			));
		}

		$groups_sql = 'SELECT DISTINCT g.group_type, g.group_name, g.group_id
			FROM ' . GROUPS_TABLE . ' g
			ORDER BY g.group_type DESC, g.group_name ASC';

		$groups = $db->sql_query($groups_sql);

		while ($row = $db->sql_fetchrow($groups))
		{
			$template->assign_block_vars('surly_trusted_groups', array(
				'ID' => $row['group_id'],
				'NAME' => ($row['group_type'] == GROUP_SPECIAL) ? $user->lang('G_' . $row['group_name']) : $row['group_name'],
				'SELECTED' => in_array($row['group_id'], $surly_trusted_groups),
			));
		}

		$template->assign_vars(array(
			'L_ACP_SURLY_DESCRIPTION_SHORTEN_URLS' => sprintf($user->lang('ACP_SURLY_DESCRIPTION_SHORTEN_URLS'), $surly_toolbar_id),
			'SURLY_REPLACE_URLS_NOWHERE' => in_array(SURLY_REPLACE_URLS_NOWHERE, $surly_replace_urls),
			'SURLY_REPLACE_URLS_POSTS' => in_array(SURLY_REPLACE_URLS_POSTS, $surly_replace_urls),
			'SURLY_SHORTEN_URLS' => $surly_shorten_urls,
			'SURLY_SUBDOMAIN' => $surly_subdomain,
			'SURLY_TRUSTED_DOMAINS_LENGTH' => count($surly_trusted_domains),
		));
	}

	function display_settings_toolbar()
	{
		global $config, $template;

		$surly_panel_url = SURLY_PANEL_URL . (!empty($config['surly_toolbar_id']) ? $config['surly_toolbar_id'] : '')
			. '/plugin_access?password=' . (!empty($config['surly_toolbar_password']) ? $config['surly_toolbar_password'] : '');

		$template->assign_vars(array(
			'U_SURLY_PANAE_URL' => $surly_panel_url,
		));
	}

	function ajax_save_toolbar_settings()
	{
		set_config('surly_toolbar_id', request_var('surly_toolbar_id', ''));
		set_config('surly_toolbar_password', request_var('surly_toolbar_password', ''));
		set_config('surly_initial', '2-1');

		$surly = surly_get_sdk();
		$surly->trackHistory(SURLY_ACTION_TYPE_AUTH);

		header('Content-Type: application/json');
		echo json_encode(array('success' => true));

		exit;
	}

	function ajax_save_subdomain()
	{
		$result = $this->save_subdomain();

		if (isset($result['error']))
		{
			header('Content-Type: application/json');
			echo json_encode(array('error' => array('subdomain' => $result['error'])));

			exit;
		}
		else
		{
			set_config('surly_initial', '2-2');
		}

		header('Content-Type: application/json');
		echo json_encode(array('success' => true));

		exit;
	}

	function ajax_save_trusted_groups()
	{
		$this->save_trusted_groups();
		set_config('surly_initial', '4-1');

		header('Content-Type: application/json');
		echo json_encode(array('success' => true));

		exit;
	}

	function ajax_save_shorten_urls()
	{
		$this->save_shorten_urls();
		set_config('surly_initial', '4-2');

		header('Content-Type: application/json');
		echo json_encode(array('success' => true));

		exit;
	}

	function ajax_save_replace_urls()
	{
		global $db, $cache;

		$this->save_replace_urls();
		set_config('surly_initial', false);

		$sql = 'UPDATE ' . MODULES_TABLE . ' SET module_display = 1 WHERE module_langname = "ACP_SURLY_TAB_TOOLBAR_SETTINGS"';
		$db->sql_query($sql);

		$cache->destroy('_modules_acp');
		$cache->destroy('sql', MODULES_TABLE);

		$surly = surly_get_sdk();
		$surly->trackHistory(SURLY_ACTION_TYPE_ACTIVATION);

		header('Content-Type: application/json');
		echo json_encode(array('success' => true));

		exit;
	}

	function ajax_skip_step()
	{
		$steps = array('1-0', '2-1', '2-2', '3-0', '4-1', '4-2');

		$next_step = request_var('next_step', '1-0');
		$next_step = in_array($next_step, $steps) ? $next_step : $steps[0];

		set_config('surly_initial', $next_step);

		header('Content-Type: application/json');
		echo json_encode(array('success' => true));

		exit;
	}

	function ajax_save_settings()
	{
		$this->save_replace_urls();
		$this->save_shorten_urls();
		$this->save_trusted_groups();

		$result = $this->save_subdomain();

		if (isset($result['error']))
		{
			header('Content-Type: application/json');
			echo json_encode(array('error' => array('subdomain' => $result['error'])));

			exit;
		}

		header('Content-Type: application/json');
		echo json_encode(array('success' => true));

		exit;
	}

	function ajax_save_trusted_domain()
	{
		global $config, $user;

		$surly_trusted_domains = !empty($config['surly_ignore_domains'])
			? json_decode($config['surly_ignore_domains'], true) : array();

		$trusted_domain = preg_replace('/^https?:\/\/(.+)/',"$1", strtolower(request_var('surly_trusted_domain', '')));

		if (empty($trusted_domain))
		{
			header('Content-Type: application/json');
			echo json_encode(array('error' => $user->lang('ACP_SURLY_ERROR_DOMAIN_NAME')));

			exit;
		}

		if (preg_match('!(?P<host>(?:[a-z0-9_-]+\.)+[a-z]+)!u', $trusted_domain, $result))
		{
			$trusted_domain = $result['host'];
		}
		else
		{
			header('Content-Type: application/json');
			echo json_encode(array('error' => $user->lang('ACP_SURLY_ERROR_DOMAIN_NAME')));

			exit;
		}

		if (in_array($trusted_domain, $surly_trusted_domains))
		{
			header('Content-Type: application/json');
			echo json_encode(array('error' => $user->lang('ACP_SURLY_ERROR_DOMAIN_EXIST')));

			exit;
		}

		set_config('surly_ignore_domains',
			json_encode(array_merge($surly_trusted_domains, array($trusted_domain)))
		);

		header('Content-Type: application/json');
		echo json_encode(array('domain' => $trusted_domain));

		exit;
	}

	function ajax_delete_trusted_domains()
	{
		global $config;

		$surly_trusted_domains = !empty($config['surly_ignore_domains'])
			? json_decode($config['surly_ignore_domains'], true) : array();

		$trusted_domains = (array) request_var('surly_trusted_domains', array(0 => ''));

		set_config('surly_ignore_domains',
			json_encode(array_diff($surly_trusted_domains, $trusted_domains))
		);

		header('Content-Type: application/json');
		echo json_encode(array('success' => true));

		exit;
	}

	function save_replace_urls()
	{
		$surly_replace_urls = (array) request_var('surly_replace_urls', array(SURLY_REPLACE_URLS_NOWHERE));
		$surly_replace_urls = array_intersect(array(SURLY_REPLACE_URLS_NOWHERE), $surly_replace_urls)
			?: array_intersect(array(SURLY_REPLACE_URLS_POSTS), $surly_replace_urls)
			?: array(SURLY_REPLACE_URLS_NOWHERE);

		set_config('surly_replace_urls', json_encode($surly_replace_urls));
	}

	function save_subdomain()
	{
		global $config, $user;

		$surly_subdomain = request_var('surly_subdomain', '');
		$config_subdomain = !empty($config['surly_subdomain']) ? $config['surly_subdomain'] : '';

		if ($surly_subdomain != $config_subdomain)
		{
			$surly = surly_get_sdk();

			if ($surly_subdomain == '')
			{
				$surly->trackHistory(SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK);
			}
			else
			{
				$result = json_decode($surly->linkSubdomain($surly_subdomain), true);

				if (isset($result['error_code']))
				{
					$errors = array(
						1 => $user->lang('ACP_SURLY_ERROR_SUBDOMAIN_REQUIRE'),
						2 => $user->lang('ACP_SURLY_ERROR_SUBDOMAIN_INVALID'),
						3 => $user->lang('ACP_SURLY_ERROR_SUBDOMAIN_EXIST'),
						4 => $user->lang('ACP_SURLY_ERROR_SUBDOMAIN_CNAME'),
						5 => $user->lang('ACP_SURLY_ERROR_UNEXPECTED'),
					);

					return isset($errors[$result['error_code']])
						? array('error' => $errors[$result['error_code']]) : array('error' => $errors[5]);
				}
				elseif (isset($result['subdomain']))
				{
					$surly_subdomain = $result['subdomain'];

					$surly->trackHistory(SURLY_ACTION_TYPE_SUBDOMAIN_LINK);
				}
				else {
					$surly_subdomain = $config_subdomain;
				}
			}
		}

		set_config('surly_subdomain', $surly_subdomain);
	}

	function save_trusted_groups()
	{
		global $db;

		$surly_trusted_groups = (array) request_var('surly_trusted_groups', array(0));

		$groups_sql = 'SELECT DISTINCT g.group_type, g.group_name, g.group_id
			FROM ' . GROUPS_TABLE . ' g
			ORDER BY g.group_type DESC, g.group_name ASC';

		$groups = $db->sql_query($groups_sql);

		$group_ids = array();

		while ($row = $db->sql_fetchrow($groups))
		{
			$group_ids[] = $row['group_id'];
		}

		foreach ($surly_trusted_groups as $key => $value)
		{
			if (!in_array($value, $group_ids))
			{
				unset($surly_trusted_groups[$key]);
			}
		}

		set_config('surly_trusted_groups', json_encode($surly_trusted_groups));
	}

	function save_shorten_urls()
	{
		set_config('surly_shorten_urls', request_var('surly_shorten_urls', false));
	}
}

?>
