<?php

/*
 * Copyright (c) 2012 Sur.ly
 * This file is part of Sur.ly phpBB plugin.
 *
 * Sur.ly phpBB plugin plugin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Sur.ly phpBB plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Sur.ly phpBB plugin.  If not, see <http://www.gnu.org/licenses/>.
 */

if (!defined('IN_PHPBB'))
{
	exit;
}

include($phpbb_root_path . 'includes/surly_phpbb.' . $phpEx);

function surly_get_sdk()
{
	global $config;

	static $surly;

	if (!isset($surly))
	{
		$surly_trusted_domains = !empty($config['surly_ignore_domains'])
			? json_decode($config['surly_ignore_domains'], true) : array();

		$surly_toolbar_id = !empty($config['surly_toolbar_id'])
			? $config['surly_toolbar_id'] : SURLY_DEFAULT_TOOLBAR_ID;

		$surly_shorten_urls = !empty($config['surly_shorten_urls']);

		$surly = new surly_phpbb($surly_toolbar_id, $surly_shorten_urls);

		if (!empty($config['surly_subdomain']))
		{
			$surly->setPanelHost($config['surly_subdomain']);
		}

		foreach ($surly_trusted_domains as $domain)
		{
			$surly->whitelist($domain);
		}

		$site_url = parse_url(generate_board_url(true), PHP_URL_HOST);

		$surly->whitelist($site_url);
	}

	return $surly;
}

function surly_process_message($message, $poster_id)
{
	global $config;

	$surly_replace_urls = !empty($config['surly_replace_urls'])
			? json_decode($config['surly_replace_urls'], true) : array(0);

	if (in_array(1, $surly_replace_urls) && !surly_is_user_ignored($poster_id))
	{
		$surly = surly_get_sdk();

		return $surly->process($message);
	}
	else
	{
		return $message;
	}
}

function surly_is_user_ignored($user_id)
{
	global $db, $config;

	$usergroups = array();

	$surly_trusted_groups = !empty($config['surly_trusted_groups'])
		? json_decode($config['surly_trusted_groups'], true) : array();

	$sql = 'SELECT u.group_id
		FROM ' . USERS_TABLE . ' u
		WHERE u.user_id = ' . (int) $user_id;

	$result = $db->sql_query($sql);
	$usergroups[] = $db->sql_fetchfield('group_id');
	$db->sql_freeresult($result);

	return (bool) array_intersect($usergroups, $surly_trusted_groups);
}

?>
