<?php
/**
*
* @package Sur.ly
* @copyright (c) 2014 Sur.ly <http://sur.ly>
* @license GNU General Public License, version 2 (GPL-2.0)
*
*/

namespace surly\surly\acp;

class surly_module
{
	public $u_action;
	public $tpl_name;
	public $page_title;

	public function main($id, $mode)
	{
		global $phpbb_container;

		$language = $phpbb_container->get('language');
		$request = $phpbb_container->get('request');
		$template = $phpbb_container->get('template');
		$config = $phpbb_container->get('config');
		$admin_controller = $phpbb_container->get('surly.surly.admin.controller');

		$language->add_lang('surly_acp', 'surly/surly');

		$template->assign_vars(array(
			'U_ACTION' => $this->u_action,
		));

		add_form_key('surly');

		if ($request->variable('action', '') && !check_form_key('surly'))
		{
			$json_response = new \phpbb\json_response;
			$json_response->send(array('error' => array('token' => $language->lang('FORM_INVALID'))));
		}

		switch($request->variable('action', ''))
		{
			case 'surly_ajax_save_toolbar_settings':
				$admin_controller->ajax_save_toolbar_settings();
				break;
			case 'surly_ajax_save_subdomain':
				$admin_controller->ajax_save_subdomain();
				break;
			case 'surly_ajax_save_trusted_groups':
				$admin_controller->ajax_save_trusted_groups();
				break;
			case 'surly_ajax_save_shorten_urls':
				$admin_controller->ajax_save_shorten_urls();
				break;
			case 'surly_ajax_save_replace_urls':
				$admin_controller->ajax_save_replace_urls();
				break;
			case 'surly_ajax_skip_step':
				$admin_controller->ajax_skip_step();
				break;
			case 'surly_ajax_save_settings':
				$admin_controller->ajax_save_settings();
				break;
			case 'surly_ajax_save_trusted_domain':
				$admin_controller->ajax_save_trusted_domain();
				break;
			case 'surly_ajax_delete_trusted_domains':
				$admin_controller->ajax_delete_trusted_domains();
				break;
		}

		$this->page_title = $language->lang('ACP_SURLY_TAB_PLUGIN_SETTINGS');

		if ($config->offsetGet('surly_initial'))
		{
			$this->tpl_name = 'template/surly-settings-initial';

			$admin_controller->display_settings_initial();
		}
		elseif ($config->offsetGet('surly_toolbar_password'))
		{
			if ($mode == 'surly-settings-toolbar')
			{
				$this->page_title = $language->lang('ACP_SURLY_TAB_TOOLBAR_SETTINGS');
				$this->tpl_name = 'template/surly-settings-toolbar';

				$admin_controller->display_settings_toolbar();
			}
			else
			{
				$this->tpl_name = 'template/surly-settings-plugin';

				$admin_controller->display_settings_plugin();
			}
		}
		else
		{
			$this->tpl_name = 'template/surly-settings-short';

			$admin_controller->display_settings_short();
		}
	}
}
