<?php
/**
*
* @package Sur.ly
* @copyright (c) 2014 Sur.ly <http://sur.ly>
* @license GNU General Public License, version 2 (GPL-2.0)
*
*/

namespace surly\surly\event;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
* Event listener
*/
class listener implements EventSubscriberInterface
{
	/** @var \phpbb\config\config */
	protected $config;

	/** @var \phpbb\controller\helper */
	protected $controller_helper;

	/** @var \phpbb\template\template */
	protected $template;

	/** @var \phpbb\user */
	protected $user;

	/** @var string phpEx */
	protected $php_ext;

	/** @var \surly\surly\operators\surly_phpbb */
	protected $surly;

	/**
	* Constructor
	*
	* @param \phpbb\config\config $config Config object
	* @param \phpbb\controller\helper $controller_helper Controller helper object
	* @param \phpbb\template\template $template Template object
	* @param \phpbb\user $user User object
	* @param string $php_ext phpEx
	* @param \surly\surly\operators\surly_phpbb $surly
	* @return \phpbb\boardrules\event\listener
	* @access public
	*/
	public function __construct(
		\phpbb\config\config $config,
		\phpbb\controller\helper $controller_helper,
		\phpbb\template\template $template,
		\phpbb\user $user,
		$php_ext,
		\surly\surly\operators\surly_phpbb $surly
		)
	{
		$this->config = $config;
		$this->controller_helper = $controller_helper;
		$this->template = $template;
		$this->user = $user;
		$this->php_ext = $php_ext;
		$this->surly = $surly;
	}

	/**
	* Assign functions defined in this class to event listeners in the core
	*
	* @return array
	* @static
	* @access public
	*/
	static public function getSubscribedEvents()
	{
		return array(
			'core.permissions' => 'add_permission',
			'core.viewtopic_modify_post_row' => 'process_post',
		);
	}

	/**
	* Add administrative permissions to manage board rules
	*
	* @param object $event The event object
	* @return null
	* @access public
	*/
	public function add_permission($event)
	{
		$permissions = $event['permissions'];
		$permissions['a_surly'] = array('lang' => 'ACL_A_SURLY', 'cat' => 'misc');
		$event['permissions'] = $permissions;
	}

	public function process_post($event)
	{
		$surly_replace_urls = $this->config->offsetGet('surly_replace_urls') ?
			json_decode($this->config['surly_replace_urls'], true) : array(\surly\surly\controller\admin_controller::SURLY_REPLACE_URLS_NOWHERE);

		if (in_array(\surly\surly\controller\admin_controller::SURLY_REPLACE_URLS_POSTS, $surly_replace_urls) && !$this->surly->is_user_ignored($event['poster_id'])) 
		{
			$post_row = $event['post_row'];
			$post_row['MESSAGE'] = $this->surly->process($post_row['MESSAGE']);
			$post_row['SIGNATURE'] = $this->surly->process($post_row['SIGNATURE']);
			$event['post_row'] = $post_row;
		}
	}
}
