<?php
/**
*
* @package Sur.ly
* @copyright (c) 2014 Sur.ly <http://sur.ly>
* @license GNU General Public License, version 2 (GPL-2.0)
*
*/

namespace surly\surly\migrations\v10x;

/**
* Migration stage 1: Initial schema
*/
class m1_initial_schema extends \phpbb\db\migration\migration
{
	/**
	* Add the surly_cache table schema to the database
	*
	* @return array Array of table schema
	* @access public
	*/
	public function update_schema()
	{
		return array(
			'add_tables'    => array(
				$this->table_prefix . 'surly_cache' => array(
					'COLUMNS' => array(
						'long_url' => array('VCHAR:255', ''),
						'hash' => array('VARBINARY', ''),
						'short_id' => array('VCHAR:10', ''),
					),
					'KEYS' => array(
						'idx' => array('UNIQUE', array('hash', 'long_url(100)'))
					),
				),
			),
		);
	}

	/**
	* Drop the surly_cache table schema from the database
	*
	* @return array Array of table schema
	* @access public
	*/
	public function revert_schema()
	{
		return array(
			'drop_tables'   => array(
				$this->table_prefix . 'surly_cache',
			),
		);
	}
}
