<?php

if (!defined('FORUM_ROOT')) die();

// Check permission
if ($forum_user['g_id'] != FORUM_ADMIN) {
	message($lang_common['No permission']);
}

require_once FORUM_ROOT . 'include/common_admin.php';
require_once $ext_info['path'] . '/include/functions.php';

// Load the admin.php language file
include FORUM_ROOT . 'lang/' . $forum_user['language'] . '/admin_common.php';
include FORUM_ROOT . 'lang/' . $forum_user['language'] . '/admin_settings.php';

if (!isset($lang_surly)) {
	if (file_exists($ext_info['path'] . '/lang/' . $forum_user['language'] . '/surly.php')) {
		include $ext_info['path'] . '/lang/' . $forum_user['language'] . '/surly.php';
	} else {
		include $ext_info['path'] . '/lang/English/surly.php';
	}
}

if (!defined('FORUM_CACHE_FUNCTIONS_LOADED')) {
	require_once FORUM_ROOT . 'include/cache.php';
}

define('FORUM_PAGE_SECTION', 'surly');
define('FORUM_PAGE', 'admin-surly');

define('SURLY_PANEL_URL', 'https://surdotly.com/settings/');

if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_toolbar_settings') {
	surly_save_toolbar_settings();
	surly_set_option('surly_initial', '2-1');

	generate_config_cache();

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_subdomain') {
	$result = surly_save_subdomain();

	if (isset($result['error'])) {
		send_json(array('error' => $result['error']));
	} else {
		surly_set_option('surly_initial', '2-2');
		generate_config_cache();
	}

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_trusted_groups') {
	surly_save_trusted_groups();
	surly_set_option('surly_initial', '4-1');

	generate_config_cache();

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_shorten_urls') {	
	surly_save_shorten_urls();
	surly_set_option('surly_initial', '4-2');	

	generate_config_cache();

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_replace_urls') {
	surly_save_replace_urls();
	surly_set_option('surly_initial', 0);	

	$surly = surly_get_sdk();
	$surly->trackHistory(SURLY_ACTION_TYPE_ACTIVATION);

	generate_config_cache();

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_skip_step') {
	surly_skip_step();

	generate_config_cache();

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_settings') {
	surly_save_replace_urls();
	surly_save_shorten_urls();
	surly_save_trusted_groups();

	$result = surly_save_subdomain();

	generate_config_cache();

	if (isset($result['error'])) {
		send_json(array('error' => $result['error']));
	}

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_trusted_domain') {
	$result = surly_save_trusted_domain();

	generate_config_cache();

	if (isset($result['error'])) {
		send_json(array('error' => $result['error']));
	} else if (isset($result['domain'])) {
		send_json(array('domain' => $result['domain']));
	}

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_delete_trusted_domains') {
	surly_delete_trusted_domains();

	generate_config_cache();

	exit();
}

function surly_save_subdomain()
{
	global $lang_surly;

	$surly_subdomain = isset($_POST['surly_subdomain']) ? trim($_POST['surly_subdomain']) : '';

	if ($surly_subdomain != surly_get_option('surly_subdomain', '')) {

		$surly = surly_get_sdk();

		if ($surly_subdomain == '') {
			$surly->trackHistory(SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK);
		} else {
			$result = json_decode($surly->linkSubdomain($surly_subdomain), true);

			if (isset($result['error_code'])) {
				$errors = array(
					1 => $lang_surly['invalid subdomain name'],
					2 => $lang_surly['is not subdomain, need valid subdomain'],
					3 => $lang_surly['subdomain already in use'],
					4 => $lang_surly['invalid cname record'],
					5 => $lang_surly['an unexpected error occured'],
				);

				return isset($errors[$result['error_code']])
					? array('error' => $errors[$result['error_code']]) : array('error' => $errors[5]);
			}
			elseif (isset($result['subdomain'])) {
				$surly_subdomain = $result['subdomain'];

				$surly->trackHistory(SURLY_ACTION_TYPE_SUBDOMAIN_LINK);
			}
			else {
				$surly_subdomain = surly_get_option('surly_subdomain', '');
			}
		}
	}

	surly_set_option('surly_subdomain', $surly_subdomain);
}

function surly_save_trusted_groups()
{
	$surly_trusted_groups = isset($_POST['surly_trusted_groups']) ? (array) $_POST['surly_trusted_groups'] : array();

	$groups = surly_get_groups();

	foreach ($surly_trusted_groups as $key => $value) {
		if (!isset($groups[$value])) {
			unset($surly_trusted_groups[$key]);
		}
	}

	surly_set_option('surly_trusted_groups', $surly_trusted_groups, true);
}

function surly_save_shorten_urls()
{
	$surly_shorten_urls = !empty($_POST['surly_shorten_urls']);

	surly_set_option('surly_shorten_urls', (int) $surly_shorten_urls);
}

function surly_save_replace_urls()
{
	$surly_replace_urls = isset($_POST['surly_replace_urls']) ? (array) $_POST['surly_replace_urls'] : array(0);
	$surly_replace_urls = array_intersect(array(0), $surly_replace_urls) ?: array_intersect(array(1), $surly_replace_urls) ?: array(0);

	surly_set_option('surly_replace_urls', $surly_replace_urls, true);
}

function surly_save_toolbar_settings()
{
	$surly_toolbar_id = isset($_POST['surly_toolbar_settings']['id']) ? $_POST['surly_toolbar_settings']['id'] : '';
	$surly_toolbar_password = isset($_POST['surly_toolbar_settings']['password']) ? $_POST['surly_toolbar_settings']['password'] : '';

	surly_set_option('surly_toolbar_id', $surly_toolbar_id);
	surly_set_option('surly_toolbar_password', $surly_toolbar_password);

	$surly = surly_get_sdk();
	$surly->trackHistory(SURLY_ACTION_TYPE_AUTH);
}

function surly_skip_step()
{
	$steps = array('1-0', '2-1', '2-2', '3-0', '4-1', '4-2');

	$next_step = isset($_POST['next_step']) && in_array($_POST['next_step'], $steps) ? $_POST['next_step'] : $steps[0];

	surly_set_option('surly_initial', $next_step);
}

function surly_save_trusted_domain()
{
	global $lang_surly;

	$trusted_domain = isset($_POST['surly_trusted_domain'])? preg_replace('/^https?:\/\/(.+)/',"$1", strtolower(trim($_POST['surly_trusted_domain']))) : '';

	if (empty($trusted_domain)) {
		return array('error' => $lang_surly['invalid domain name']);
	}

	if (preg_match('!(?P<host>(?:[a-z0-9_-]+\.)+[a-z]+)!u', $trusted_domain, $result)) {
		$trusted_domain = $result['host'];
	} else {
		return array('error' => $lang_surly['invalid domain name']);
	}

	if (in_array($trusted_domain, surly_get_option('surly_trusted_domains', array(), true))) {
		return array('error' => $lang_surly['domain exists']);
	}

	surly_set_option('surly_trusted_domains',
		array_merge(surly_get_option('surly_trusted_domains', array(), true), array($trusted_domain)),
		true
	);

	return array('domain' => $trusted_domain);
}

function surly_delete_trusted_domains()
{
	$trusted_domains = isset($_POST['surly_trusted_domains']) ? (array) $_POST['surly_trusted_domains'] : array();

	surly_set_option('surly_trusted_domains',		
		array_diff(surly_get_option('surly_trusted_domains', array(), true), $trusted_domains),
		true
	);
}

// Setup breadcrumbs
$forum_page['crumbs'] = array(
	array($forum_config['o_board_title'], forum_link($forum_url['index'])),
	array($lang_admin_common['Forum administration'], forum_link($forum_url['admin_index'])),
	array('Sur.ly', forum_link($forum_url['surly'])),
);

if (surly_get_option('surly_initial', false)) {
	$template = $ext_info['path'] . '/template/surly-settings-initial.php';
} else if (surly_get_option('surly_toolbar_id', false)) {
	if (isset($_GET['tab']) && $_GET['tab'] == SURLY_TAB_SETTINGS_TOOLBAR) {
		$template = $ext_info['path'] . '/template/surly-settings-toolbar.php';

		$forum_page['crumbs'][] = array($lang_surly['toolbar settings'], forum_link($forum_url['surly_toolbar']));

	} else {
		$template = $ext_info['path'] . '/template/surly-settings-plugin.php';
	}
} else {
	$template = $ext_info['path'] . '/template/surly-settings-short.php';
}

require_once FORUM_ROOT . 'header.php';

// START SUBST - <!-- forum_main -->
ob_start();

require_once $template;

$tpl_temp = forum_trim(ob_get_contents());
$tpl_main = str_replace('<!-- forum_main -->', $tpl_temp, $tpl_main);
ob_end_clean();
// END SUBST - <!-- forum_main -->

require_once FORUM_ROOT . 'footer.php';