<?php

$errors = array();

if (file_exists(dirname(__FILE__) . '/SSI.php') && !defined('SMF')) {
	require_once(dirname(__FILE__) . '/SSI.php');
} elseif (!defined('SMF')) {
	$errors[] = '<b>Error:</b> Cannot install - please verify that you put this file in the same place as SMF\'s index.php and SSI.php files.';
}

if ((SMF == 'SSI') && !$user_info['is_admin']) {
	$errors[] = '<b>Error:</b> Admin privileges required.';
}

if (!empty($errors)) {
	die(implode('<br />', $errors));
}
	
$hooks = array(
	'integrate_pre_include' => '$sourcedir/surly/Subs-Surly.php',
	'integrate_menu_buttons' => 'surly_menu_buttons',
	'integrate_actions' => 'surly_actions',
);

foreach ($hooks as $hook => $function)
	add_integration_function($hook, $function);

updateSettings(array('surly_activation_hash' => md5(time())));

if (SMF == 'SSI')
	echo 'Database changes are complete! Please wait...';

?>