<?php

if (!defined('SMF'))
	die();
	
function surly_menu_buttons(&$buttons) {
	global $scripturl, $context;

	$buttons['surly'] = array(
		'title' => 'Sur.ly',
		'href' => $scripturl . '?action=surly',
		'show' => $context['allow_admin'],
		'sub_buttons' => array(),
	);
}

function surly_actions(&$actions) {
	global $sourcedir;

	$actions['surly'] = array('surly/Surly.php', 'surlyView');

	if (isset($_REQUEST['action']) && preg_match('/^surly_ajax_/', $_REQUEST['action'])) {

		isAllowedTo('admin_forum');

		require_once $sourcedir . '/surly/Surly.php';

		$data = array();

		switch ($_REQUEST['action']) {
			case 'surly_ajax_save_settings':
				$data = surlyAjaxSaveSettings();
				break;
			case 'surly_ajax_save_toolbar_settings':
				$data = surlyAjaxSaveToolbarSettings();
				break;
			case 'surly_ajax_save_subdomain':
				$data = surlyAjaxSaveSubdomain();
				break;
			case 'surly_ajax_save_trusted_domain':
				$data = surlyAjaxSaveTrustedDomain();
				break;
			case 'surly_ajax_delete_trusted_domains':
				$data = surlyAjaxDeleteTrustedDomains();
				break;
			case 'surly_ajax_save_trusted_groups':
				$data = surlyAjaxSaveTrustedGroups();
				break;
			case 'surly_ajax_save_shorten_urls':
				$data = surlyAjaxSaveShortenUrls();
				break;
			case 'surly_ajax_save_replace_urls':
				$data = surlyAjaxSaveReplaceUrls();
				break;
			case 'surly_ajax_skip_step':
				$data = surlyAjaxSkipStep();
				break;
		}

		header('Content-Type: application/json');
		echo json_encode($data);
		exit;
	}
}