
<?php

global $db_prefix, $user_info, $boardurl, $boarddir, $sourcedir, $txt, $dbinstall_string;

// Load the SSI.php
if (file_exists(dirname(__FILE__) . '/SSI.php') && !defined('SMF'))
{
	function _dbinst_write($string) { echo $string; }

	require_once(dirname(__FILE__) . '/SSI.php');

	// on manual installation you have to logged in
	if(!$user_info['is_admin'])
	{
		if($user_info['is_guest'])
		{
			echo '<b>', $txt['admin_login'],':</b><br />';
			ssi_login($boardurl.'/dbinstall.php');
			die();
		}
		else
		{
			loadLanguage('Errors');
			fatal_error($txt['cannot_admin_forum']);
		}
	}
}
// no SSI.php and no SMF?
elseif (!defined('SMF'))
	die('<b>Error:</b> SSI.php not found. Please verify you put this in the same place as SMF\'s index.php.');
else
{
	function _dbinst_write($string)
	{
		global $dbinstall_string;
		$dbinstall_string .= $string;
	}
}

// split of dbname (mostly for SSI)
$pref = explode('.', $db_prefix);
if(!empty($pref[1]))
	$pref = $pref[1];
else
	$pref = $db_prefix;

$dbinstall_string = '';

// Load the SMF DB Functions
db_extend('packages');
db_extend('extra');

/********************
* Define the tables *
*********************/

$table_data = array(
	'surly_cache' => array(
		array(
			// fields
			array(
				'name' => 'long_url',
				'type' => 'varchar',
				'size' => 1000,
				'unsigned' => false,
				'auto' => false,
			),
			array(
				'name' => 'hash',
				'type' => 'binary',
				'size' => 16,
				'unsigned' => false,
				'auto' => false,
			),
			array(
				'name' => 'short_id',
				'type' => 'varchar',
				'size' => 10,
				'unsigned' => true,
				'auto' => false,
			),
		),
		array(
			// indexes
			array(
				'type' => 'primary',
				'columns' => array('hash', 'long_url(100)'),
			),
		),
	),
);

foreach($table_data as $tbl_name => $structure)
{
	list($cols, $index) = $structure;

	$smcFunc['db_create_table']('{db_prefix}'. $tbl_name, $cols, $index, '', 'error');
}

?>
