<?php

function template_surlySettingsPlugin() {
	global $txt, $scripturl;

	$surly_replace_urls = surlyGetOption('surly_replace_urls', array(0), true);
	$surly_trusted_groups = surlyGetOption('surly_trusted_groups', array(), true);
	$surly_trusted_domains = surlyGetOption('surly_trusted_domains', array(), true);

	echo '
	<div style="overflow: hidden;">
		<ul class="dropmenu">
			<li>
				<a class="firstlevel active" href="', $scripturl . '?action=surly;sa=', SURLY_TAB_SETTINGS_PLUGIN, '">
					<span class="firstlevel">', $txt['surly_tab_plugin_settings'], '</span>
				</a>
			</li>
			<li>
				<a class="firstlevel" href="', $scripturl . '?action=surly;sa=', SURLY_TAB_SETTINGS_TOOLBAR, '">
					<span class="firstlevel">', $txt['surly_tab_toolbar_settings'], '</span>
				</a>
			</li>
		</ul>
	</div>
	<br class="clear"/>
	<div class="wrapper-surly">
		<div id="surly-message" class="alert-success" style="display:none">
			<p>', $txt['surly_message_settings_saved'], '</p>
		</div>
		<div class="ps-window">
			<div class="ps-central-content">
				<div class="ps-rows-settings">
					<form id="surly-save-settings-form">
						<input type="hidden" name="action" value="surly_ajax_save_settings"/>
						<div id="surly-replace-urls" class="ps-row-box">
							<div class="ps-inner-box">
								<div class="ps-title-box">
									<p>', $txt['surly_title_replace_urls'], '</p>
								</div>
								<div class="ps-table-box">
									<div class="ps-cell">
										<div class="w280">
											<div class="ps-list-in', in_array(0, $surly_replace_urls) ? ' field-error' : '', '">
												<ul>
													<li>
														<label for="surly_replace_urls_nowhere">', $txt['surly_option_nowhere'], '</label>
														<input
															id="surly_replace_urls_nowhere"
															name="surly_replace_urls[]"
															value="0"
															type="checkbox"',
															in_array(0, $surly_replace_urls) ? 'checked="checked"' : '', '/>
													</li>
													<li>
														<label for="surly_replace_urls_posts">', $txt['surly_option_posts'], '</label>
														<input
															id="surly_replace_urls_posts"
															name="surly_replace_urls[]"
															value="1"
															type="checkbox"',
															in_array(1, $surly_replace_urls) ? 'checked="checked"' : '', '/>
													</li>
												</ul>
											</div>
										</div>
									</div>
									<div class="ps-cell">
										<div class="surly-field-error" data-field="surly-replace-urls">
											<div class="', in_array(0, $surly_replace_urls) ? 'ps-title-cell red show' : 'hide', '">
												<p>', $txt['surly_message_configuration_surly'], '</p>
											</div>
										</div>
										<div class="ps-title-cell">
											<p>', $txt['surly_description_replace_urls'], '</p>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="ps-row-box">
							<div class="ps-inner-box">
								<div class="ps-title-box">
									<p>', $txt['surly_title_shorten_urls'], '</p>
								</div>
								<div class="ps-cell">
									<div class="w280">
										<div class="ps-cell">
											<div class="ps-select-in">
												<select name="surly_shorten_urls">
													<option value="0"', !surlyGetOption('surly_shorten_urls', false) ? ' selected="selected"' : '', '>', $txt['surly_option_disable'], '</option>
													<option value="1"', surlyGetOption('surly_shorten_urls', false) ? ' selected="selected"' : '', '>', $txt['surly_option_enable'], '</option>
												</select>
											</div>
										</div>
									</div>
								</div>
								<div class="ps-cell">
									<div class="ps-title-cell">
										<p>', sprintf($txt['surly_description_shorten_urls'], surlyGetOption('surly_toolbar_id', SURLY_DEFAULT_TOOLBAR_ID)), '</p>
									</div>
								</div>
							</div>
						</div>
						<div id="surly-subdomain" class="ps-row-box">
							<div class="ps-inner-box">
								<div class="ps-title-box">
									<p>', $txt['surly_title_subdomain'], '</p>
								</div>
								<div class="ps-table-box">
									<div class="ps-cell">
										<div class="w280">
											<div class="ps-type-in">
												<input name="surly_subdomain" value="', surlyGetOption('surly_subdomain', ''), '" type="text" placeholder="', $txt['surly_placeholder_url'], '"/>
											</div>
										</div>
									</div>
									<div class="ps-cell">
										<div class="surly-field-error" data-field="surly-subdomain"></div>
										<div class="ps-title-cell">
											<p>', $txt['surly_description_subdomain'], '</p>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="ps-row-box">
							<div class="ps-inner-box">
								<div class="ps-title-box">
									<p>', $txt['surly_title_trusted_groups'], '</p>
								</div>
								<div class="ps-table-box">
									<div class="ps-cell">
										<div class="w280">
											<div class="ps-list-in trusted-groups">
												<ul>';
												foreach(surlyGetGroups() as $id => $name) {
													echo '
													<li>
														<label for="surly_trusted_groups-', $id, '">', $name, '</label>
														<input
															id="surly_trusted_groups-', $id, '"
															name="surly_trusted_groups[]"
															value="', $id, '"
															type="checkbox"',
															in_array($id, $surly_trusted_groups) ? 'checked="checked"' : '', '/>
													</li>';
												}
												echo '
												</ul>
											</div>
										</div>
									</div>
									<div class="ps-cell">
										<div class="ps-title-cell">
											<p>', $txt['surly_description_trusted_groups'], '</p>
										</div>
									</div>
								</div>
							</div>
						</div>
					</form>
					<form id="surly-trusted-domains">
						<div class="ps-row-box">
							<div class="ps-inner-box">
								<div class="ps-title-box">
									<p>', $txt['surly_title_trusted_domains'], '</p>
								</div>
								<div class="ps-table-box">
									<div class="ps-cell">
										<div class="w430">
											<div class="ps-type-in">
												<input id="surly-trusted-domain" name="surly_trusted_domain" value="" placeholder="', $txt['surly_placeholder_domain'], '"/>
												<div class="ps-type-buttons">
													<a id="surly-save-trusted-domain" href="#" class="ps-type-button blue">', $txt['surly_button_add_domain'], '</a>
												</div>
											</div>
										</div>
									</div>
									<div class="ps-cell">
										<div class="surly-field-error" data-field="surly-trusted-domain"></div>
										<div class="ps-title-cell">
											<p>', $txt['surly_description_trusted_domains'], '</p>
										</div>
									</div>
								</div>
								<div class="ps-central-box">
									<div class="ps-table-line">
										<ul>
											<li class="first">
												<span class="ps-type-check">
													<input type="checkbox" value="1" id="surly_trusted_domains"/>
												</span>
												<label for="surly_trusted_domains">', $txt['surly_label_domain'], '</label>
												<span class="num-item">', count($surly_trusted_domains) > 1 ? (count($surly_trusted_domains) . $txt['surly_label_items']) : (1 . $txt['surly_label_item']), '</span>
											</li>';
											foreach ($surly_trusted_domains as $key => $value) {
												echo '
												<li class="inner">
													<span class="ps-type-check">
														<input
															id="surly_trusted_domains-', $key, '"
															name="surly_trusted_domains[]"
															value="', $value, '"
															type="checkbox"/>
													</span>
													<label for="surly_trusted_domains-', $key, '">', $value, '</label>
												</li>';
											}
											echo '
											<li class="empty', !empty($surly_trusted_domains) ? ' hide' : '', '">
												<label>', $txt['surly_label_no_items_found'], '</label>
											</li>
										</ul>
										<div class="ps-type-buttons">
											<a id="surly-delete-trusted-domains" href="#" class="ps-type-button ps-border lred pad30">', $txt['surly_button_delete'], '</a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</form>
				</div>
				<div class="ps-type-buttons">
					<a id="surly-save-settings" href="#" class="ps-type-button blue">', $txt['surly_button_save_changes'], '</a>
				</div>
			</div>
		</div>
	</div>';
}

?>
