<?php

$errors = array();

if (file_exists(dirname(__FILE__) . '/SSI.php') && !defined('SMF')) {
	require_once(dirname(__FILE__) . '/SSI.php');
} elseif (!defined('SMF')) {
	$errors[] = '<b>Error:</b> Cannot install - please verify that you put this file in the same place as SMF\'s index.php and SSI.php files.';
}

if ((SMF == 'SSI') && !$user_info['is_admin']) {
	$errors[] = '<b>Error:</b> Admin privileges required.';
}

if (!empty($errors)) {
	die(implode('<br />', $errors));
}

$hooks = array(
	'integrate_pre_include' => '$sourcedir/surly/Subs-Surly.php',
	'integrate_menu_buttons' => 'surly_menu_buttons',
	'integrate_actions' => 'surly_actions',
);

foreach ($hooks as $hook => $function)
	remove_integration_function($hook, $function);

$smcFunc['db_query']('', 'DELETE FROM {db_prefix}settings WHERE variable IN ({array_string:setting_list})', array(
	'setting_list' => array(
		'surly_initial',
		'surly_activation_hash',
		'surly_trusted_domains',
		'surly_trusted_groups',
		'surly_shorten_urls',
		'surly_toolbar_id',
		'surly_toolbar_password',
		'surly_subdomain',
		'surly_replace_urls',
	),
));

if (SMF == 'SSI')
	echo 'Database changes are complete! Please wait...';

?>