<?php

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array();
$specialtemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// ############################# LOG ACTION ###############################
log_admin_action();

// ######################## CHECK ADMIN PERMISSIONS #######################
if (!can_administer('canadminsettings')) {
    print_cp_no_permission();
}

require_once(DIR . '/includes/surly/surly_functions.php');

define('SURLY_PANEL_URL', 'https://surdotly.com/settings/');

define('SURLY_TAB_SETTINGS_PLUGIN', 'settings-plugin');
define('SURLY_TAB_SETTINGS_TOOLBAR', 'settings-toolbar');

if ($_REQUEST['do'] == SURLY_TAB_SETTINGS_PLUGIN)
{
    $headinsert = '<link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Noto+Sans:400,400i,700,700i"/>'
        . '<link rel="stylesheet" type="text/css" href="../includes/surly/static/css/font-awesome.min.css"/>'
        . '<link rel="stylesheet" type="text/css" href="../includes/surly/static/css/surly-style.css"/>'
        . '<link rel="stylesheet" type="text/css" href="../includes/surly/static/css/chosen.css"/>'
        . '<script type="text/javascript" src="../includes/surly/static/js/jquery-1.8.2.min.js"></script>'
        . '<script type="text/javascript" src="../includes/surly/static/js/chosen.jquery.min.js"></script>'
        . '<script type="text/javascript" src="../includes/surly/static/js/jquery.icheck.min.js"></script>'
        . '<script type="text/javascript" src="../includes/surly/static/js/jquery.postMessage.min.js"></script>'
        . '<script type="text/javascript" src="../includes/surly/static/js/surly-script.js"></script>';

    $surly_replace_urls = json_decode($vbulletin->options['surly_replace_urls'], true);
    $surly_trusted_domains = json_decode($vbulletin->options['surly_trusted_domains'], true);
    $surly_trusted_groups = json_decode($vbulletin->options['surly_trusted_groups'], true);
    $surly_initial = $vbulletin->options['surly_initial'] ?: '1-0';

    print_cp_header($vbphrase['surly_tab_plugin_settings'], '', $headinsert);

    if ($vbulletin->options['surly_initial'])
    {
        require_once DIR . '/includes/surly/surly-settings-initial.php';
    }
    else if ($vbulletin->options['surly_toolbar_id'])
    {
        require_once DIR . '/includes/surly/surly-settings-plugin.php';
    }
    else
    {
        require_once DIR . '/includes/surly/surly-settings-short.php';
    }

    print_cp_footer();
}
else if ($_REQUEST['do'] == SURLY_TAB_SETTINGS_TOOLBAR)
{
    $headinsert = '<link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Noto+Sans:400,400i,700,700i"/>'
        . '<link rel="stylesheet" type="text/css" href="../includes/surly/static/css/font-awesome.min.css"/>'
        . '<link rel="stylesheet" type="text/css" href="../includes/surly/static/css/surly-style.css"/>';

    print_cp_header($vbphrase['surly_tab_toolbar_settings'], '', $headinsert);

    require_once DIR . '/includes/surly/surly-settings-toolbar.php';

    print_cp_footer();
}
else if ($_REQUEST['do'] == 'surly_ajax_save_toolbar_settings')
{
    $surly_toolbar_id = isset($_REQUEST['surly_toolbar_id'])
        ? $_REQUEST['surly_toolbar_id']
        : '';

    $surly_toolbar_password = isset($_REQUEST['surly_toolbar_password'])
        ? $_REQUEST['surly_toolbar_password']
        : '';

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '" . $vbulletin->db->escape_string($surly_toolbar_id) . "'
        WHERE varname = 'surly_toolbar_id'");

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '" . $vbulletin->db->escape_string($surly_toolbar_password) . "'
        WHERE varname = 'surly_toolbar_password'");

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '2-1'
        WHERE varname = 'surly_initial'");

    build_options();

    $surly = new vB_Surly($vbulletin);
    $surly->trackHistory(SURLY_ACTION_TYPE_AUTH);

    echo json_encode(array('success' => true));
    die();
}
else if ($_REQUEST['do'] == 'surly_ajax_save_subdomain')
{
    $result = surly_save_subdomain();

    @header('Content-Type: application/json');

    if (isset($result['error']))
    {
        echo json_encode(array('error' => array('subdomain' => $result['error'])));
        die();
    }

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '2-2'
        WHERE varname = 'surly_initial'");

    build_options();

    echo json_encode(array('success' => true));
    die();
}
else if ($_REQUEST['do'] == 'surly_ajax_save_trusted_groups')
{
    surly_save_trusted_groups();

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '4-1'
        WHERE varname = 'surly_initial'");

    build_options();

    echo json_encode(array('success' => true));
    die();
}
else if ($_REQUEST['do'] == 'surly_ajax_save_shorten_urls')
{
    surly_save_shorten_urls();

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '4-2'
        WHERE varname = 'surly_initial'");

    build_options();

    echo json_encode(array('success' => true));
    die();
}
else if ($_REQUEST['do'] == 'surly_ajax_save_replace_urls')
{
    surly_save_replace_urls();

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '0'
        WHERE varname = 'surly_initial'");

    build_options();

    $surly = new vB_Surly($vbulletin);
    $surly->trackHistory(SURLY_ACTION_TYPE_ACTIVATION);

    echo json_encode(array('success' => true));
    die();
}
else if ($_REQUEST['do'] == 'surly_ajax_skip_step')
{
    $steps = array( '1-0', '2-1', '2-2', '3-0', '4-1', '4-2' );

    $next_step = isset($_REQUEST['next_step']) && in_array($_REQUEST['next_step'], $steps)
        ? $_REQUEST['next_step']
        : $steps[0];

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '" . $vbulletin->db->escape_string($next_step) . "'
        WHERE varname = 'surly_initial'");

    build_options();

    echo json_encode(array('success' => true));
    die();
}
else if ($_REQUEST['do'] == 'surly_ajax_save_settings')
{
    surly_save_replace_urls();
    surly_save_shorten_urls();
    surly_save_trusted_groups();

    $result = surly_save_subdomain();

    @header('Content-Type: application/json');

    if (isset($result['error']))
    {
        echo json_encode(array('error' => array('subdomain' => $result['error'])));
        die();
    }

    echo json_encode(array('success' => true));
    die();
}
else if ($_REQUEST['do'] == 'surly_ajax_save_trusted_domain')
{
    $trusted_domain = isset($_REQUEST['surly_trusted_domain'])
        ? preg_replace('/^https?:\/\/(.+)/',"$1", strtolower(trim($_REQUEST['surly_trusted_domain'])))
        : '';

    @header('Content-Type: application/json');

    if (empty($trusted_domain))
    {
        echo json_encode(array('error' => $vbphrase['surly_error_domain_name']));
        die();
    }

    if (preg_match('!(?P<host>(?:[a-z0-9_-]+\.)+[a-z]+)!u', $trusted_domain, $result))
    {
        $trusted_domain = $result['host'];
    }
    else
    {
        echo json_encode(array('error' => $vbphrase['surly_error_domain_name']));
        die();
    }

    $surly_trusted_domains = json_decode($vbulletin->options['surly_trusted_domains'], true);

    if (in_array($trusted_domain, $surly_trusted_domains))
    {
        echo json_encode(array('error' => $vbphrase['surly_error_domain_exist']));
        die();
    }

    $surly_trusted_domains = array_merge($surly_trusted_domains, array($trusted_domain));

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '" . $vbulletin->db->escape_string(json_encode($surly_trusted_domains)) . "'
        WHERE varname = 'surly_trusted_domains'");

    build_options();

    echo json_encode(array('domain' => $trusted_domain));
    die();
}
else if ($_REQUEST['do'] == 'surly_ajax_delete_trusted_domains')
{
    $trusted_domains = isset($_REQUEST['surly_trusted_domains'])
        ? (array) $_REQUEST['surly_trusted_domains']
        : array();

    $surly_trusted_domains = json_decode($vbulletin->options['surly_trusted_domains'], true);
    $surly_trusted_domains = array_diff($surly_trusted_domains, $trusted_domains);

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '" . $vbulletin->db->escape_string(json_encode($surly_trusted_domains)) . "'
        WHERE varname = 'surly_trusted_domains'");

    build_options();

    @header('Content-Type: application/json');

    echo json_encode(array('success' => true));
    die();
}

function surly_get_membergroup()
{
    global $vbulletin, $iusergroupcache;

    $uniqueid = fetch_uniqueid_counter();

    if (!is_array($iusergroupcache))
    {
        $iusergroupcache = array();

        $usergroups = $vbulletin->db->query_read('SELECT usergroupid, title FROM ' . TABLE_PREFIX . 'usergroup ORDER BY title');

        while ($usergroup = $vbulletin->db->fetch_array($usergroups))
        {
            $iusergroupcache["$usergroup[usergroupid]"] = $usergroup['title'];
        }

        unset($usergroup);

        $vbulletin->db->free_result($usergroups);
    }

    return $iusergroupcache;
}

function surly_save_subdomain()
{
    global $vbulletin, $vbphrase;

    $surly_subdomain = isset($_REQUEST['surly_subdomain'])
        ? $_REQUEST['surly_subdomain']
        : '';

    if ($surly_subdomain != $vbulletin->options['surly_subdomain'])
    {
        $surly = new vB_Surly($vbulletin);

        if ($surly_subdomain == '')
        {
            $surly->trackHistory(SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK);
        }
        else
        {
            $result = json_decode($surly->linkSubdomain($surly_subdomain), true);

            if (isset($result['error_code']))
            {
                $errors = array(
                    1 => $vbphrase['surly_error_subdomain_require'],
                    2 => $vbphrase['surly_error_subdomain_invalid'],
                    3 => $vbphrase['surly_error_subdomain_exist'],
                    4 => $vbphrase['surly_error_subdomain_cname'],
                    5 => $vbphrase['surly_error_unexpected'],
                );

                return isset($errors[$result['error_code']])
                    ? array('error' => $errors[$result['error_code']])
                    : array('error' => $errors[5]);
            }
            elseif (isset($result['subdomain']))
            {
                $surly_subdomain = $result['subdomain'];

                $surly->trackHistory(SURLY_ACTION_TYPE_SUBDOMAIN_LINK);
            }
            else
            {
                $surly_subdomain = $vbulletin->options['surly_subdomain'];
            }
        }
    }

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '" . $vbulletin->db->escape_string($surly_subdomain) . "'
        WHERE varname = 'surly_subdomain'");

    build_options();
}

function surly_save_trusted_groups()
{
    global $vbulletin;

    $surly_trusted_groups = isset($_REQUEST['surly_trusted_groups'])
        ? (array) $_REQUEST['surly_trusted_groups']
        : array();

    $groups = surly_get_membergroup();

    foreach ($surly_trusted_groups as $key => $value)
    {
        if (!isset($groups[$value]))
        {
            unset($surly_trusted_groups[$key]);
        }
    }

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '" . $vbulletin->db->escape_string(json_encode($surly_trusted_groups)) . "'
        WHERE varname = 'surly_trusted_groups'");

    build_options();
}

function surly_save_shorten_urls()
{
    global $vbulletin;

    $surly_shorten_urls = !empty($_REQUEST['surly_shorten_urls']);

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '" . $vbulletin->db->escape_string((int) $surly_shorten_urls) . "'
        WHERE varname = 'surly_shorten_urls'");

    build_options();
}

function surly_save_replace_urls()
{
    global $vbulletin;

    $surly_replace_urls = isset($_REQUEST['surly_replace_urls'])
        ? (array) $_REQUEST['surly_replace_urls']
        : array(0);

    $surly_replace_urls = array_intersect(array(0), $surly_replace_urls)
        ?: array_intersect(array(1), $surly_replace_urls)
        ?: array(0);

    $vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "setting
        SET value = '" . $vbulletin->db->escape_string(json_encode($surly_replace_urls)) . "'
        WHERE varname = 'surly_replace_urls'");

    build_options();
}
