from surly import Surly
import hashlib


class MemcacheSurly(Surly):

    ROOT_STATUS_KEY = '_surly_root_status'

    def __init__(self, memcache_client, toolbar_id=None, use_shortener=False, host=None):
        self.memcache_client = memcache_client
        super(MemcacheSurly, self).__init__(toolbar_id, use_shortener, host)

    def _cache_short_ids(self, remote_short_ids):
        for url, shortened in remote_short_ids.items():
            self.memcache_client[hashlib.md5(url).hexdigest()] = shortened

    def _get_cached_short_ids(self, urls):
        url2shortened = {}
        for url in urls:
            try:
                url2shortened[url] = self.memcache_client[hashlib.md5(url).hexdigest()]
            except KeyError:
                continue
        return url2shortened

    def _get_cached_root_status(self):
        try:
            return self.memcache_client[self.ROOT_STATUS_KEY]
        except KeyError:
            return {}

    def _cache_root_status(self, root_domain_alive_info):
        self.memcache_client[self.ROOT_STATUS_KEY] = root_domain_alive_info
