from mock import MagicMock
import unittest
from surly import Surly
import inspect
from test_helper import TestHelper


class ShortnerTest(TestHelper):

    def _get_data(self, method_name, type):
        self.test_name = 'shortner'
        return super(ShortnerTest, self)._get_data(method_name, type)

    def _mock_surly_remote_request(self, answer, toolbar_id, use_shortner=True, surly=None):
        if not surly:
            surly = Surly(toolbar_id=toolbar_id, use_shortener=use_shortner)

        surly._shorten_remotely = MagicMock(return_value=answer)

        return surly

    def setUp(self):
        super(ShortnerTest, self).setUp()
        self.host = 'example.com'
        self.toolbar_id = 'AA001753'

    def test_shorten(self):
        surly = Surly()
        self.assertEqual(
            '{"urls":{"ixbt.com":"qx"},"errors":[]}',
            surly._perform_request(
                surly.api_host + surly.api_path,
                'POST',
                {
                    'raw': 1,
                    'urls': 'ixbt.com'
                }
            )
        )

    def test_shorten_with_www(self):
        this_method_name = inspect.stack()[0][3]
        surly = self._mock_surly_remote_request(
            {'google.com': 'gl'},
            toolbar_id=None
        )

        self.assertEqual(
            surly.process(self._get_data(this_method_name, 'in')),
            self._get_data(this_method_name, 'expected')
        )

    def test_shorten_with_fragment(self):
        this_method_name = inspect.stack()[0][3]
        surly = self._mock_surly_remote_request(
            {'google.com': 'gl'},
            toolbar_id=None
        )

        self.assertEqual(
            surly.process(self._get_data(this_method_name, 'in')),
            self._get_data(this_method_name, 'expected')
        )

    def test_dont_shorten_invalid_urls(self):
        this_method_name = inspect.stack()[0][3]
        surly = self._mock_surly_remote_request(
            {'google.com': 'gl'},
            toolbar_id=None
        )

        self.assertEqual(
            surly.process(self._get_data(this_method_name, 'in')),
            self._get_data(this_method_name, 'expected')
        )

    def test_dont_shorten_invalid_urls_with_toolbar_id(self):
        this_method_name = inspect.stack()[0][3]
        surly = self._mock_surly_remote_request(
            {'google.com': 'gl'},
            toolbar_id=self.toolbar_id
        )

        self.assertEqual(
            surly.process(self._get_data(this_method_name, 'in')),
            self._get_data(this_method_name, 'expected')
        )


if __name__ == '__main__':
    unittest.main()

