from abc import ABCMeta, abstractmethod
import unittest
import os


class TestHelper(unittest.TestCase):
    __metaclass__ = ABCMeta

    def setUp(self):
        super(TestHelper, self).setUp()
        self.current_dir = os.path.dirname(__file__)

    @abstractmethod
    def _get_data(self, method_name, type):
        with open(self.current_dir + '/fixtures/'+ self.test_name +'/' + type + '/' + method_name[5:] + '.html', 'r') as input_file:
            return input_file.read()
